/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.JLabelModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class AWTLabel
extends Component
implements JLabelModel {
    private static final Font FONT = new Font("SansSerif", 1, 10);
    private static final int MARGIN = 2;
    private static final int MIN_HEIGHT = 16;
    private String label;
    private int alignment;

    public AWTLabel() {
        this.setFont(JTFTools.getStandardFont(FONT));
    }

    public void setText(String text) {
        this.label = text;
        this.repaint();
    }

    public String getText() {
        return this.label;
    }

    public void setHorizontalAlignment(int align) {
        this.alignment = align;
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.getForeground());
        FontMetrics fm = g.getFontMetrics();
        int x = 2;
        switch (this.alignment) {
            case 0: {
                x = (size.width - fm.stringWidth(this.label)) / 2;
                break;
            }
            case 4: {
                x = size.width - fm.stringWidth(this.label) - 2;
            }
        }
        int y = (size.height + fm.getAscent()) / 2 - 2;
        g.drawString(this.label, x, y);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.repaint();
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.repaint();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = Math.max(fm.getHeight() + 2, 16);
        return new Dimension(fm.stringWidth(this.label) + 4, height);
    }
}

